/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.health;

import io.micronaut.health.CurrentHealthStatus;
import io.micronaut.health.HealthStatus;
import jakarta.inject.Singleton;
import java.util.concurrent.atomic.AtomicReference;

@Singleton
class DefaultCurrentHealthStatus
implements CurrentHealthStatus {
    private final AtomicReference<HealthStatus> current = new AtomicReference<HealthStatus>(HealthStatus.UP);

    DefaultCurrentHealthStatus() {
    }

    @Override
    public HealthStatus current() {
        return this.current.get();
    }

    @Override
    public HealthStatus update(HealthStatus newStatus) {
        if (newStatus != null) {
            return this.current.getAndSet(newStatus);
        }
        return this.current.get();
    }
}

