/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ConfigurationProperties(value="micronaut.security.token.jwt.cookie")
public class JwtCookieConfigurationProperties
implements JwtCookieConfiguration {
    public static final String PREFIX = "micronaut.security.token.jwt.cookie";
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_SECURE = true;
    public static final boolean DEFAULT_HTTPONLY = true;
    public static final String DEFAULT_COOKIENAME = "JWT";
    public static final String DEFAULT_COOKIEPATH = "/";
    public static final String DEFAULT_LOGOUTTARGETURL = "/";
    public static final String DEFAULT_LOGINSUCCESSTARGETURL = "/";
    public static final String DEFAULT_LOGINFAILURETARGETURL = "/";
    private String cookieDomain;
    private String cookiePath = "/";
    private Boolean cookieHttpOnly = true;
    private Boolean cookieSecure = true;
    private Duration cookieMaxAge;
    private boolean enabled = false;
    private String logoutTargetUrl = "/";
    private String cookieName = "JWT";
    private String loginSuccessTargetUrl = "/";
    private String loginFailureTargetUrl = "/";

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getLogoutTargetUrl() {
        return this.logoutTargetUrl;
    }

    @Override
    public String getLoginSuccessTargetUrl() {
        return this.loginSuccessTargetUrl;
    }

    @Override
    public String getLoginFailureTargetUrl() {
        return this.loginFailureTargetUrl;
    }

    public void setLogoutTargetUrl(String logoutTargetUrl) {
        if (StringUtils.isNotEmpty((CharSequence)logoutTargetUrl)) {
            this.logoutTargetUrl = logoutTargetUrl;
        }
    }

    public void setLoginSuccessTargetUrl(String loginSuccessTargetUrl) {
        if (StringUtils.isNotEmpty((CharSequence)loginSuccessTargetUrl)) {
            this.loginSuccessTargetUrl = loginSuccessTargetUrl;
        }
    }

    public void setLoginFailureTargetUrl(String loginFailureTargetUrl) {
        if (StringUtils.isNotEmpty((CharSequence)loginFailureTargetUrl)) {
            this.loginFailureTargetUrl = loginFailureTargetUrl;
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Nonnull
    public String getCookieName() {
        return this.cookieName;
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.cookieDomain);
    }

    @Nullable
    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

