/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.JwtGeneratorConfiguration;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JwtCookieLoginHandler
implements RedirectingLoginHandler {
    protected final JwtCookieConfiguration jwtCookieConfiguration;
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;
    protected final JwtGeneratorConfiguration jwtGeneratorConfiguration;

    public JwtCookieLoginHandler(JwtCookieConfiguration jwtCookieConfiguration, JwtGeneratorConfiguration jwtGeneratorConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.jwtGeneratorConfiguration = jwtGeneratorConfiguration;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    public HttpResponse loginSuccess(UserDetails userDetails, HttpRequest<?> request) {
        Optional<Cookie> cookieOptional = this.accessTokenCookie(userDetails, request);
        if (!cookieOptional.isPresent()) {
            return HttpResponse.serverError();
        }
        Cookie cookie = cookieOptional.get();
        return this.loginSuccessWithCookies(Arrays.asList(cookie));
    }

    public HttpResponse loginFailed(AuthenticationFailed authenticationFailed) {
        try {
            URI location = new URI(this.jwtCookieConfiguration.getLoginFailureTargetUrl());
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    protected Optional<Cookie> accessTokenCookie(UserDetails userDetails, HttpRequest<?> request) {
        Optional<AccessRefreshToken> accessRefreshTokenOptional = this.accessRefreshTokenGenerator.generate(userDetails);
        if (accessRefreshTokenOptional.isPresent()) {
            Cookie cookie = Cookie.of((String)this.jwtCookieConfiguration.getCookieName(), (String)accessRefreshTokenOptional.get().getAccessToken());
            cookie.configure((CookieConfiguration)this.jwtCookieConfiguration, request.isSecure());
            Optional cookieMaxAge = this.jwtCookieConfiguration.getCookieMaxAge();
            if (cookieMaxAge.isPresent()) {
                cookie.maxAge((TemporalAmount)cookieMaxAge.get());
            } else {
                cookie.maxAge((long)this.jwtGeneratorConfiguration.getAccessTokenExpiration().intValue());
            }
            return Optional.of(cookie);
        }
        return Optional.empty();
    }

    protected HttpResponse loginSuccessWithCookies(List<Cookie> cookies) {
        try {
            URI location = new URI(this.jwtCookieConfiguration.getLoginSuccessTargetUrl());
            MutableHttpResponse mutableHttpResponse = HttpResponse.seeOther((URI)location);
            for (Cookie cookie : cookies) {
                mutableHttpResponse = mutableHttpResponse.cookie(cookie);
            }
            return mutableHttpResponse;
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }
}

