/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import io.micronaut.security.token.reader.TokenReader;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JwtCookieTokenReader
implements TokenReader {
    public static final Integer ORDER = 0;
    protected final JwtCookieConfiguration jwtCookieConfiguration;

    public JwtCookieTokenReader(JwtCookieConfiguration jwtCookieConfiguration) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
    }

    public Optional<String> findToken(HttpRequest<?> request) {
        Optional optionalCookie = request.getCookies().findCookie((CharSequence)this.jwtCookieConfiguration.getCookieName());
        return optionalCookie.map(Cookie::getValue);
    }

    public int getOrder() {
        return ORDER;
    }
}

