/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.encryption.rsa;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import io.micronaut.security.token.jwt.encryption.AbstractEncryptionConfiguration;
import io.micronaut.security.token.jwt.encryption.rsa.RSAEncryptionConfiguration;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;

public class RSAEncryption
extends AbstractEncryptionConfiguration {
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;

    public RSAEncryption(RSAEncryptionConfiguration rsaEncryptionConfiguration) {
        this.method = rsaEncryptionConfiguration.getEncryptionMethod();
        this.algorithm = rsaEncryptionConfiguration.getJweAlgorithm();
        this.publicKey = rsaEncryptionConfiguration.getPublicKey();
        this.privateKey = rsaEncryptionConfiguration.getPrivateKey();
    }

    @Override
    public boolean supports(JWEAlgorithm algorithm, EncryptionMethod method) {
        if (algorithm != null && method != null) {
            return RSADecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && RSADecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(method);
        }
        return false;
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return "Only RSA algorithms are supported with the appropriate encryption method";
    }

    @Override
    protected JWEEncrypter buildEncrypter() {
        return this.buildEncrypterWithPublicKey(this.publicKey);
    }

    private JWEEncrypter buildEncrypterWithPublicKey(@Nonnull RSAPublicKey publicKey) {
        return new RSAEncrypter(publicKey);
    }

    @Override
    protected JWEDecrypter buildDecrypter() {
        return this.buildDecrypterWithPrivateKey(this.privateKey);
    }

    private JWEDecrypter buildDecrypterWithPrivateKey(@Nonnull RSAPrivateKey privateKey) {
        return new RSADecrypter((PrivateKey)privateKey);
    }
}

