/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.token.jwt.endpoints.TokenRefreshRequest;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import io.micronaut.security.token.jwt.validator.JwtTokenValidator;
import io.micronaut.security.token.validator.TokenValidator;
import io.micronaut.validation.Validated;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.endpoints.oauth.enabled", value="true")
@Controller(value="${micronaut.security.endpoints.oauth.path:/oauth/access_token}")
@Secured(value={"isAnonymous()"})
@Validated
public class OauthController {
    private static final Logger LOG = LoggerFactory.getLogger(OauthController.class);
    protected final TokenValidator tokenValidator;
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;

    public OauthController(JwtTokenValidator tokenValidator, AccessRefreshTokenGenerator accessRefreshTokenGenerator) {
        this.tokenValidator = tokenValidator;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public Single<HttpResponse<AccessRefreshToken>> index(@Valid TokenRefreshRequest tokenRefreshRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("grantType: {} refreshToken: {}", (Object)tokenRefreshRequest.getGrantType(), (Object)tokenRefreshRequest.getRefreshToken());
        }
        Flowable authenticationFlowable = Flowable.fromPublisher((Publisher)this.tokenValidator.validateToken(tokenRefreshRequest.getRefreshToken()));
        return authenticationFlowable.map(authentication -> {
            Map claims = authentication.getAttributes();
            Optional<AccessRefreshToken> accessRefreshToken = this.accessRefreshTokenGenerator.generate(tokenRefreshRequest.getRefreshToken(), claims);
            if (accessRefreshToken.isPresent()) {
                return HttpResponse.ok((Object)accessRefreshToken.get());
            }
            return HttpResponse.serverError();
        }).first((Object)HttpResponse.status((HttpStatus)HttpStatus.FORBIDDEN));
    }
}

