/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.generator.TokenGenerator;
import io.micronaut.security.token.jwt.event.AccessTokenGeneratedEvent;
import io.micronaut.security.token.jwt.event.RefreshTokenGeneratedEvent;
import io.micronaut.security.token.jwt.generator.JwtGeneratorConfiguration;
import io.micronaut.security.token.jwt.generator.claims.ClaimsGenerator;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import io.micronaut.security.token.jwt.render.TokenRenderer;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccessRefreshTokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AccessRefreshTokenGenerator.class);
    protected final ClaimsGenerator claimsGenerator;
    protected final JwtGeneratorConfiguration jwtGeneratorConfiguration;
    protected final TokenRenderer tokenRenderer;
    protected final TokenGenerator tokenGenerator;
    protected final ApplicationEventPublisher eventPublisher;

    public AccessRefreshTokenGenerator(JwtGeneratorConfiguration jwtGeneratorConfiguration, TokenRenderer tokenRenderer, TokenGenerator tokenGenerator, ClaimsGenerator claimsGenerator, ApplicationEventPublisher eventPublisher) {
        this.jwtGeneratorConfiguration = jwtGeneratorConfiguration;
        this.tokenRenderer = tokenRenderer;
        this.tokenGenerator = tokenGenerator;
        this.claimsGenerator = claimsGenerator;
        this.eventPublisher = eventPublisher;
    }

    public Optional<AccessRefreshToken> generate(UserDetails userDetails) {
        Optional accessToken = this.tokenGenerator.generateToken(userDetails, this.jwtGeneratorConfiguration.getAccessTokenExpiration());
        Optional refreshToken = this.tokenGenerator.generateToken(userDetails, this.jwtGeneratorConfiguration.getRefreshTokenExpiration());
        if (!accessToken.isPresent() || !refreshToken.isPresent()) {
            if (LOG.isDebugEnabled()) {
                if (!accessToken.isPresent()) {
                    LOG.debug("tokenGenerator failed to generate access token for userDetails {}", (Object)userDetails.getUsername());
                }
                if (!refreshToken.isPresent()) {
                    LOG.debug("tokenGenerator failed to generate refreshToken token for userDetails {}", (Object)userDetails.getUsername());
                }
            }
            return Optional.empty();
        }
        AccessRefreshToken accessRefreshToken = this.tokenRenderer.render(userDetails, this.jwtGeneratorConfiguration.getAccessTokenExpiration(), (String)accessToken.get(), (String)refreshToken.get());
        this.eventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent(accessRefreshToken.getAccessToken()));
        this.eventPublisher.publishEvent((Object)new RefreshTokenGeneratedEvent(accessRefreshToken.getRefreshToken()));
        return Optional.of(accessRefreshToken);
    }

    public Optional<AccessRefreshToken> generate(String refreshToken, Map<String, Object> oldClaims) {
        Map<String, Object> claims = this.claimsGenerator.generateClaimsSet(oldClaims, this.jwtGeneratorConfiguration.getAccessTokenExpiration());
        Optional optionalAccessToken = this.tokenGenerator.generateToken(claims);
        if (!optionalAccessToken.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("tokenGenerator failed to generate access token claims: {}", (Object)claims.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
            }
            return Optional.empty();
        }
        String accessToken = (String)optionalAccessToken.get();
        this.eventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent(accessToken));
        return Optional.of(this.tokenRenderer.render(this.jwtGeneratorConfiguration.getAccessTokenExpiration(), accessToken, refreshToken));
    }
}

