/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.render;

import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import io.micronaut.security.token.jwt.render.BearerAccessRefreshToken;
import io.micronaut.security.token.jwt.render.TokenRenderer;
import javax.inject.Singleton;

@Singleton
public class BearerTokenRenderer
implements TokenRenderer {
    private final String BEARER_TOKEN_TYPE = "Bearer";

    @Override
    public AccessRefreshToken render(Integer expiresIn, String accessToken, String refreshToken) {
        return new AccessRefreshToken(accessToken, refreshToken, "Bearer", expiresIn);
    }

    @Override
    public AccessRefreshToken render(UserDetails userDetails, Integer expiresIn, String accessToken, String refreshToken) {
        return new BearerAccessRefreshToken(userDetails.getUsername(), userDetails.getRoles(), expiresIn, accessToken, refreshToken, "Bearer");
    }
}

