/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.ec;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.security.token.jwt.signature.AbstractSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.ec.ECSignatureConfiguration;
import java.security.interfaces.ECPublicKey;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECSignature
extends AbstractSignatureConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ECSignature.class);
    private ECPublicKey publicKey;

    public ECSignature(ECSignatureConfiguration config) {
        if (!this.supports(config.getJwsAlgorithm())) {
            throw new ConfigurationException(this.supportedAlgorithmsMessage());
        }
        this.algorithm = config.getJwsAlgorithm();
        this.publicKey = config.getPublicKey();
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return "Only the ES256, ES384 and ES512 algorithms are supported for elliptic curve signature";
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return algorithm != null && ECDSAVerifier.SUPPORTED_ALGORITHMS.contains(algorithm);
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        return this.verify(jwt, this.publicKey);
    }

    private boolean verify(SignedJWT jwt, @Nonnull ECPublicKey publicKey) throws JOSEException {
        ECDSAVerifier verifier = new ECDSAVerifier(this.publicKey);
        return jwt.verify((JWSVerifier)verifier);
    }
}

