/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.ec;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.security.token.jwt.signature.SignatureGeneratorConfiguration;
import io.micronaut.security.token.jwt.signature.ec.ECSignature;
import io.micronaut.security.token.jwt.signature.ec.ECSignatureGeneratorConfiguration;
import java.security.interfaces.ECPrivateKey;
import javax.annotation.Nonnull;

public class ECSignatureGenerator
extends ECSignature
implements SignatureGeneratorConfiguration {
    private ECPrivateKey privateKey;

    public ECSignatureGenerator(ECSignatureGeneratorConfiguration config) {
        super(config);
        this.privateKey = config.getPrivateKey();
    }

    @Override
    public SignedJWT sign(JWTClaimsSet claims) throws JOSEException {
        return this.signWithPrivateKey(claims, this.privateKey);
    }

    protected SignedJWT signWithPrivateKey(JWTClaimsSet claims, @Nonnull ECPrivateKey privateKey) throws JOSEException {
        ECDSASigner signer = new ECDSASigner(privateKey);
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(this.algorithm), claims);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }
}

