/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.rsa;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.security.token.jwt.endpoints.JwkProvider;
import io.micronaut.security.token.jwt.signature.SignatureGeneratorConfiguration;
import io.micronaut.security.token.jwt.signature.rsa.RSASignature;
import io.micronaut.security.token.jwt.signature.rsa.RSASignatureGeneratorConfiguration;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import javax.annotation.Nonnull;

public class RSASignatureGenerator
extends RSASignature
implements SignatureGeneratorConfiguration {
    private RSAPrivateKey privateKey;
    private String keyId;

    public RSASignatureGenerator(RSASignatureGeneratorConfiguration config) {
        super(config);
        if (!this.supports(config.getJwsAlgorithm())) {
            throw new ConfigurationException(this.supportedAlgorithmsMessage());
        }
        this.algorithm = config.getJwsAlgorithm();
        this.privateKey = config.getPrivateKey();
        if (config instanceof JwkProvider) {
            ((JwkProvider)((Object)config)).retrieveJsonWebKeys().stream().map(JWK::getKeyID).findFirst().ifPresent(keyIdentifier -> {
                this.keyId = keyIdentifier;
            });
        }
    }

    @Override
    public SignedJWT sign(JWTClaimsSet claims) throws JOSEException {
        return this.signWithPrivateKey(claims, this.privateKey);
    }

    protected SignedJWT signWithPrivateKey(JWTClaimsSet claims, @Nonnull RSAPrivateKey privateKey) throws JOSEException {
        RSASSASigner signer = new RSASSASigner((PrivateKey)privateKey);
        JWSHeader jwsHeader = new JWSHeader.Builder(this.algorithm).keyID(this.keyId).build();
        SignedJWT signedJWT = new SignedJWT(jwsHeader, claims);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }
}

