/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.validator.AuthenticationJWTClaimsSetAdapter;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import java.text.ParseException;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJwtAuthenticationFactory
implements JwtAuthenticationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwtAuthenticationFactory.class);

    @Override
    public Optional<Authentication> createAuthentication(JWT token) {
        try {
            JWTClaimsSet claimSet = token.getJWTClaimsSet();
            return Optional.of(new AuthenticationJWTClaimsSetAdapter(claimSet));
        }
        catch (ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("ParseException creating authentication", (Object)e.getMessage());
            }
            return Optional.empty();
        }
    }
}

