/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import io.micronaut.security.token.jwt.generator.claims.JwtClaimsSetAdapter;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.DefaultJwtAuthenticationFactory;
import io.micronaut.security.token.jwt.validator.ExpirationJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import io.micronaut.security.token.jwt.validator.JwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtTokenValidatorUtils;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JwtTokenValidator
implements TokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JwtTokenValidator.class);
    protected final List<SignatureConfiguration> signatureConfigurations = new ArrayList<SignatureConfiguration>();
    protected final List<EncryptionConfiguration> encryptionConfigurations = new ArrayList<EncryptionConfiguration>();
    protected final List<GenericJwtClaimsValidator> genericJwtClaimsValidators = new ArrayList<GenericJwtClaimsValidator>();
    protected final JwtAuthenticationFactory jwtAuthenticationFactory;

    @Inject
    public JwtTokenValidator(Collection<SignatureConfiguration> signatureConfigurations, Collection<EncryptionConfiguration> encryptionConfigurations, Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators, JwtAuthenticationFactory jwtAuthenticationFactory) {
        this.signatureConfigurations.addAll(signatureConfigurations);
        this.encryptionConfigurations.addAll(encryptionConfigurations);
        this.genericJwtClaimsValidators.addAll(genericJwtClaimsValidators);
        this.jwtAuthenticationFactory = jwtAuthenticationFactory;
    }

    @Deprecated
    public JwtTokenValidator(Collection<SignatureConfiguration> signatureConfigurations, Collection<EncryptionConfiguration> encryptionConfigurations) {
        this(signatureConfigurations, encryptionConfigurations, Collections.singleton(new ExpirationJwtClaimsValidator()), new DefaultJwtAuthenticationFactory());
    }

    public Optional<JWT> validatePlainJWTSignature(JWT jwt) {
        return JwtTokenValidatorUtils.validatePlainJWTSignature(jwt, this.signatureConfigurations);
    }

    public Optional<JWT> validateSignedJWTSignature(SignedJWT signedJWT) {
        return JwtTokenValidatorUtils.validateSignedJWTSignature(signedJWT, this.signatureConfigurations);
    }

    @Deprecated
    public boolean verifyClaims(JWTClaimsSet jwtClaimsSet, Collection<? extends JwtClaimsValidator> claimsValidators) {
        return JwtTokenValidatorUtils.verifyClaims(new JwtClaimsSetAdapter(jwtClaimsSet), claimsValidators);
    }

    @Deprecated
    public Optional<JWT> validateEncryptedJWTSignature(EncryptedJWT encryptedJWT, String token) {
        return JwtTokenValidatorUtils.validateEncryptedJWTSignature(encryptedJWT, token, this.signatureConfigurations, this.encryptionConfigurations);
    }

    public Publisher<Authentication> validateToken(String token) {
        Optional<Authentication> authentication = this.authenticationIfValidJwtSignatureAndClaims(token, this.genericJwtClaimsValidators);
        if (authentication.isPresent()) {
            return Flowable.just((Object)authentication.get());
        }
        return Flowable.empty();
    }

    public Optional<Authentication> authenticationIfValidJwtSignatureAndClaims(String token, Collection<? extends JwtClaimsValidator> claimsValidators) {
        Optional<JWT> jwt = this.validateJwtSignatureAndClaims(token, claimsValidators);
        if (jwt.isPresent()) {
            return this.jwtAuthenticationFactory.createAuthentication(jwt.get());
        }
        return Optional.empty();
    }

    public Optional<JWT> validateJwtSignatureAndClaims(String token) {
        return this.validateJwtSignatureAndClaims(token, this.genericJwtClaimsValidators);
    }

    public boolean validate(String token) {
        return this.validateJwtSignatureAndClaims(token).isPresent();
    }

    public boolean validate(String token, Collection<? extends JwtClaimsValidator> claimsValidators) {
        return this.validateJwtSignatureAndClaims(token, claimsValidators).isPresent();
    }

    @Deprecated
    public Optional<JWT> validateJwtSignatureAndClaims(String token, Collection<? extends JwtClaimsValidator> claimsValidators) {
        return JwtTokenValidatorUtils.validateJwtSignatureAndClaims(token, claimsValidators, this.signatureConfigurations, this.encryptionConfigurations);
    }

    @Deprecated
    public Optional<JWT> parseJwtIfValidSignature(String token) {
        return JwtTokenValidatorUtils.parseJwtIfValidSignature(token, this.signatureConfigurations, this.encryptionConfigurations);
    }

    public List<SignatureConfiguration> getSignatureConfigurations() {
        return this.signatureConfigurations;
    }

    public List<EncryptionConfiguration> getEncryptionConfigurations() {
        return this.encryptionConfigurations;
    }

    public List<GenericJwtClaimsValidator> getGenericJwtClaimsValidators() {
        return this.genericJwtClaimsValidators;
    }
}

