/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.bearer;

import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.handlers.LoginHandler;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import java.util.Optional;
import javax.inject.Singleton;

@Requires(property="micronaut.security.token.jwt.bearer.enabled", notEquals="false")
@Primary
@Singleton
public class AccessRefreshTokenLoginHandler
implements LoginHandler {
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;

    public AccessRefreshTokenLoginHandler(AccessRefreshTokenGenerator accessRefreshTokenGenerator) {
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    public MutableHttpResponse<?> loginSuccess(UserDetails userDetails, HttpRequest<?> request) {
        Optional<AccessRefreshToken> accessRefreshTokenOptional = this.accessRefreshTokenGenerator.generate(userDetails);
        if (accessRefreshTokenOptional.isPresent()) {
            return HttpResponse.ok((Object)accessRefreshTokenOptional.get());
        }
        return HttpResponse.serverError();
    }

    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed) {
        throw new AuthenticationException((String)authenticationFailed.getMessage().orElse(null));
    }
}

