/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.handlers.LogoutHandler;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JwtCookieClearerLogoutHandler
implements LogoutHandler {
    protected final JwtCookieConfiguration jwtCookieConfiguration;

    public JwtCookieClearerLogoutHandler(JwtCookieConfiguration jwtCookieConfiguration) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
    }

    public MutableHttpResponse<?> logout(HttpRequest<?> request) {
        Optional maybeCookie = request.getCookies().findCookie((CharSequence)this.jwtCookieConfiguration.getCookieName());
        try {
            URI location = new URI(this.jwtCookieConfiguration.getLogoutTargetUrl());
            if (maybeCookie.isPresent()) {
                Cookie requestCookie = (Cookie)maybeCookie.get();
                String domain = this.jwtCookieConfiguration.getCookieDomain().orElse(null);
                String path = this.jwtCookieConfiguration.getCookiePath().orElse(null);
                Cookie responseCookie = Cookie.of((String)requestCookie.getName(), (String)"");
                responseCookie.maxAge(0L).domain(domain).path(path);
                return HttpResponse.seeOther((URI)location).cookie(responseCookie);
            }
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException var5) {
            return HttpResponse.serverError();
        }
    }
}

