/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.handlers.RedirectingLoginHandler;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.AccessTokenConfiguration;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JwtCookieLoginHandler
implements RedirectingLoginHandler {
    protected final JwtCookieConfiguration jwtCookieConfiguration;
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;
    protected final AccessTokenConfiguration accessTokenConfiguration;

    public JwtCookieLoginHandler(JwtCookieConfiguration jwtCookieConfiguration, AccessTokenConfiguration accessTokenConfiguration, AccessRefreshTokenGenerator accessRefreshTokenGenerator) {
        this.jwtCookieConfiguration = jwtCookieConfiguration;
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
    }

    public MutableHttpResponse<?> loginSuccess(UserDetails userDetails, HttpRequest<?> request) {
        Optional<Cookie> cookieOptional = this.accessTokenCookie(userDetails, request);
        if (!cookieOptional.isPresent()) {
            return HttpResponse.serverError();
        }
        Cookie cookie = cookieOptional.get();
        return this.loginSuccessWithCookies(Arrays.asList(cookie));
    }

    public MutableHttpResponse<?> loginFailed(AuthenticationResponse authenticationFailed) {
        try {
            URI location = new URI(this.jwtCookieConfiguration.getLoginFailureTargetUrl());
            return HttpResponse.seeOther((URI)location);
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    protected Optional<Cookie> accessTokenCookie(UserDetails userDetails, HttpRequest<?> request) {
        Optional<AccessRefreshToken> accessRefreshTokenOptional = this.accessRefreshTokenGenerator.generate(userDetails);
        if (accessRefreshTokenOptional.isPresent()) {
            Cookie cookie = Cookie.of((String)this.jwtCookieConfiguration.getCookieName(), (String)accessRefreshTokenOptional.get().getAccessToken());
            cookie.configure((CookieConfiguration)this.jwtCookieConfiguration, request.isSecure());
            Optional cookieMaxAge = this.jwtCookieConfiguration.getCookieMaxAge();
            if (cookieMaxAge.isPresent()) {
                cookie.maxAge((TemporalAmount)cookieMaxAge.get());
            } else {
                cookie.maxAge((TemporalAmount)Duration.ofSeconds(this.accessTokenConfiguration.getExpiration().intValue()));
            }
            return Optional.of(cookie);
        }
        return Optional.empty();
    }

    protected MutableHttpResponse<?> loginSuccessWithCookies(List<Cookie> cookies) {
        try {
            URI location = new URI(this.jwtCookieConfiguration.getLoginSuccessTargetUrl());
            MutableHttpResponse mutableHttpResponse = HttpResponse.seeOther((URI)location);
            for (Cookie cookie : cookies) {
                mutableHttpResponse = mutableHttpResponse.cookie(cookie);
            }
            return mutableHttpResponse;
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }
}

