/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.jwt.endpoints.TokenRefreshRequest;
import io.micronaut.security.token.jwt.generator.AccessRefreshTokenGenerator;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import io.micronaut.security.token.jwt.validator.JwtTokenValidator;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import io.micronaut.security.token.validator.TokenValidator;
import io.micronaut.validation.Validated;
import io.reactivex.Single;
import java.util.Optional;
import javax.validation.Valid;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(property="micronaut.security.endpoints.oauth.enabled", value="true"), @Requires(beans={RefreshTokenPersistence.class})})
@Controller(value="${micronaut.security.endpoints.oauth.path:/oauth/access_token}")
@Secured(value={"isAnonymous()"})
@Validated
public class OauthController {
    private static final Logger LOG = LoggerFactory.getLogger(OauthController.class);
    protected final TokenValidator tokenValidator;
    protected final AccessRefreshTokenGenerator accessRefreshTokenGenerator;
    private final RefreshTokenPersistence refreshTokenPersistence;
    private final RefreshTokenValidator refreshTokenValidator;

    public OauthController(JwtTokenValidator tokenValidator, AccessRefreshTokenGenerator accessRefreshTokenGenerator, RefreshTokenPersistence refreshTokenPersistence, RefreshTokenValidator refreshTokenValidator) {
        this.tokenValidator = tokenValidator;
        this.accessRefreshTokenGenerator = accessRefreshTokenGenerator;
        this.refreshTokenPersistence = refreshTokenPersistence;
        this.refreshTokenValidator = refreshTokenValidator;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public Single<HttpResponse<AccessRefreshToken>> index(@Valid TokenRefreshRequest tokenRefreshRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("grantType: {} refreshToken: {}", (Object)tokenRefreshRequest.getGrantType(), (Object)tokenRefreshRequest.getRefreshToken());
        }
        Publisher userDetailsPublisher = this.refreshTokenValidator.validate(tokenRefreshRequest.getRefreshToken()).map(arg_0 -> ((RefreshTokenPersistence)this.refreshTokenPersistence).getUserDetails(arg_0)).orElseGet(Publishers::empty);
        return Single.fromPublisher((Publisher)userDetailsPublisher).map(userDetails -> {
            Optional<AccessRefreshToken> accessRefreshToken = this.accessRefreshTokenGenerator.generate(tokenRefreshRequest.getRefreshToken(), (UserDetails)userDetails);
            if (accessRefreshToken.isPresent()) {
                return HttpResponse.ok((Object)accessRefreshToken.get());
            }
            return HttpResponse.serverError();
        });
    }
}

