/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.event.AccessTokenGeneratedEvent;
import io.micronaut.security.token.event.RefreshTokenGeneratedEvent;
import io.micronaut.security.token.generator.RefreshTokenGenerator;
import io.micronaut.security.token.generator.TokenGenerator;
import io.micronaut.security.token.jwt.generator.AccessTokenConfiguration;
import io.micronaut.security.token.jwt.generator.RefreshTokenConfiguration;
import io.micronaut.security.token.jwt.generator.claims.ClaimsGenerator;
import io.micronaut.security.token.jwt.render.AccessRefreshToken;
import io.micronaut.security.token.jwt.render.TokenRenderer;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccessRefreshTokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AccessRefreshTokenGenerator.class);
    protected final RefreshTokenGenerator refreshTokenGenerator;
    protected final ClaimsGenerator claimsGenerator;
    protected final AccessTokenConfiguration accessTokenConfiguration;
    protected final RefreshTokenConfiguration refreshTokenConfiguration;
    protected final TokenRenderer tokenRenderer;
    protected final TokenGenerator tokenGenerator;
    protected final ApplicationEventPublisher eventPublisher;

    public AccessRefreshTokenGenerator(AccessTokenConfiguration accessTokenConfiguration, RefreshTokenConfiguration refreshTokenConfiguration, TokenRenderer tokenRenderer, TokenGenerator tokenGenerator, @Nullable RefreshTokenGenerator refreshTokenGenerator, ClaimsGenerator claimsGenerator, ApplicationEventPublisher eventPublisher) {
        this.accessTokenConfiguration = accessTokenConfiguration;
        this.refreshTokenConfiguration = refreshTokenConfiguration;
        this.tokenRenderer = tokenRenderer;
        this.tokenGenerator = tokenGenerator;
        this.refreshTokenGenerator = refreshTokenGenerator;
        this.claimsGenerator = claimsGenerator;
        this.eventPublisher = eventPublisher;
    }

    public Optional<AccessRefreshToken> generate(UserDetails userDetails) {
        Optional refreshToken = Optional.empty();
        if (this.refreshTokenConfiguration.isEnabled()) {
            if (this.refreshTokenGenerator == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Failed to add a refresh token to the response. There is no refresh token generator.");
                }
            } else {
                String key = this.refreshTokenGenerator.createKey(userDetails);
                refreshToken = this.refreshTokenGenerator.generate(userDetails, key);
                refreshToken.ifPresent(t -> this.eventPublisher.publishEvent((Object)new RefreshTokenGeneratedEvent(userDetails, key)));
            }
        }
        return this.generate((String)refreshToken.orElse(null), userDetails);
    }

    public Optional<AccessRefreshToken> generate(String refreshToken, Map<String, Object> oldClaims) {
        Map<String, Object> claims = this.claimsGenerator.generateClaimsSet(oldClaims, this.accessTokenConfiguration.getExpiration());
        Optional optionalAccessToken = this.tokenGenerator.generateToken(claims);
        if (!optionalAccessToken.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("tokenGenerator failed to generate access token claims: {}", (Object)claims.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
            }
            return Optional.empty();
        }
        String accessToken = (String)optionalAccessToken.get();
        this.eventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent((Object)accessToken));
        return Optional.of(this.tokenRenderer.render(this.accessTokenConfiguration.getExpiration(), accessToken, refreshToken));
    }

    public Optional<AccessRefreshToken> generate(String refreshToken, UserDetails userDetails) {
        Optional optionalAccessToken = this.tokenGenerator.generateToken(userDetails, this.accessTokenConfiguration.getExpiration());
        if (!optionalAccessToken.isPresent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to generate access token for user {}", (Object)userDetails.getUsername());
            }
            return Optional.empty();
        }
        String accessToken = (String)optionalAccessToken.get();
        this.eventPublisher.publishEvent((Object)new AccessTokenGeneratedEvent((Object)accessToken));
        return Optional.of(this.tokenRenderer.render(userDetails, this.accessTokenConfiguration.getExpiration(), accessToken, refreshToken));
    }
}

