/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.SupplierUtil;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.token.generator.RefreshTokenGenerator;
import io.micronaut.security.token.jwt.generator.RefreshTokenConfiguration;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(beans={RefreshTokenPersistence.class})
public class SignedRefreshTokenGenerator
implements RefreshTokenGenerator,
RefreshTokenValidator {
    private static final Logger LOG = LoggerFactory.getLogger(SignedRefreshTokenGenerator.class);
    private final Supplier<Cipher> encryptingCipher;
    private final Supplier<Cipher> decryptingCipher;

    public SignedRefreshTokenGenerator(RefreshTokenConfiguration configuration) {
        String secret = configuration.getSecret().orElse(null);
        Supplier secretKey = secret != null ? SupplierUtil.memoized(() -> this.generateSecretKey(secret.toCharArray())) : () -> {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Cannot generate a refresh token without a secret. Configure micronaut.security.token.jwt.generator.refresh-token.secret");
            }
            return null;
        };
        IvParameterSpec iv = new IvParameterSpec(new byte[8]);
        this.encryptingCipher = SupplierUtil.memoized(() -> SignedRefreshTokenGenerator.lambda$new$2((Supplier)secretKey, iv));
        this.decryptingCipher = SupplierUtil.memoized(() -> SignedRefreshTokenGenerator.lambda$new$3((Supplier)secretKey, iv));
    }

    public String createKey(UserDetails userDetails) {
        return UUID.randomUUID().toString();
    }

    public Optional<String> generate(UserDetails userDetails, String token) {
        block3: {
            Cipher cipher = this.encryptingCipher.get();
            if (cipher != null) {
                try {
                    byte[] encryptedToken = cipher.doFinal(token.getBytes(StandardCharsets.UTF_8));
                    return Optional.of(new String(Base64.getEncoder().encode(encryptedToken), StandardCharsets.UTF_8));
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Failed to sign the refresh token", (Throwable)e);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<String> validate(String refreshToken) {
        block3: {
            Cipher cipher = this.decryptingCipher.get();
            if (cipher != null) {
                byte[] token = Base64.getDecoder().decode(refreshToken);
                try {
                    byte[] decrypted = cipher.doFinal(token);
                    return Optional.of(new String(decrypted, StandardCharsets.UTF_8));
                }
                catch (BadPaddingException | IllegalBlockSizeException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("Failed to decrypt a refresh token", (Throwable)e);
                }
            }
        }
        return Optional.empty();
    }

    private byte[] generateSecretKey(char[] secret) {
        try {
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(secret, "micronaut".getBytes(), 1000, 192);
            SecretKey tempKey = skf.generateSecret(spec);
            return tempKey.getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Failed to initialize the secret key to sign refresh tokens", (Throwable)e);
            }
            return null;
        }
    }

    private static /* synthetic */ Cipher lambda$new$3(Supplier secretKey, IvParameterSpec iv) {
        block3: {
            byte[] key = (byte[])secretKey.get();
            if (key != null) {
                try {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(key, "DESede");
                    Cipher encrypt = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                    encrypt.init(2, (Key)secretKeySpec, iv);
                    return encrypt;
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Failed to initialize the secret key to sign refresh tokens", (Throwable)e);
                }
            }
        }
        return null;
    }

    private static /* synthetic */ Cipher lambda$new$2(Supplier secretKey, IvParameterSpec iv) {
        block3: {
            byte[] key = (byte[])secretKey.get();
            if (key != null) {
                try {
                    SecretKeySpec secretKeySpec = new SecretKeySpec(key, "DESede");
                    Cipher encrypt = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                    encrypt.init(1, (Key)secretKeySpec, iv);
                    return encrypt;
                }
                catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Failed to initialize the secret key to sign refresh tokens", (Throwable)e);
                }
            }
        }
        return null;
    }
}

