/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JwtAuthenticationFactory;
import io.micronaut.security.token.jwt.validator.JwtValidator;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class JwtTokenValidator
implements TokenValidator {
    protected final JwtAuthenticationFactory jwtAuthenticationFactory;
    private final JwtValidator validator;

    @Inject
    public JwtTokenValidator(Collection<SignatureConfiguration> signatureConfigurations, Collection<EncryptionConfiguration> encryptionConfigurations, Collection<GenericJwtClaimsValidator> genericJwtClaimsValidators, JwtAuthenticationFactory jwtAuthenticationFactory) {
        this(JwtValidator.builder().withSignatures(signatureConfigurations).withEncryptions(encryptionConfigurations).withClaimValidators(genericJwtClaimsValidators).build(), jwtAuthenticationFactory);
    }

    public JwtTokenValidator(JwtValidator validator, JwtAuthenticationFactory jwtAuthenticationFactory) {
        this.validator = validator;
        this.jwtAuthenticationFactory = jwtAuthenticationFactory;
    }

    public Publisher<Authentication> validateToken(String token) {
        return (Publisher)this.validator.validate(token).flatMap(this.jwtAuthenticationFactory::createAuthentication).map(Flowable::just).orElse(Flowable.empty());
    }
}

