/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.Authenticator;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import io.micronaut.security.event.LoginFailedEvent;
import io.micronaut.security.event.LoginSuccessfulEvent;
import io.micronaut.security.handlers.LoginHandler;
import io.micronaut.validation.Validated;
import io.reactivex.Flowable;
import io.reactivex.Single;
import javax.validation.Valid;

@Requires(property="micronaut.security.endpoints.login.enabled", value="true")
@Controller(value="${micronaut.security.endpoints.login.path:/login}")
@Secured(value={"isAnonymous()"})
@Validated
public class LoginController {
    protected final Authenticator authenticator;
    protected final LoginHandler loginHandler;
    protected final ApplicationEventPublisher eventPublisher;

    public LoginController(Authenticator authenticator, LoginHandler loginHandler, ApplicationEventPublisher eventPublisher) {
        this.authenticator = authenticator;
        this.loginHandler = loginHandler;
        this.eventPublisher = eventPublisher;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public Single<HttpResponse> login(@Valid @Body UsernamePasswordCredentials usernamePasswordCredentials, HttpRequest<?> request) {
        Flowable authenticationResponseFlowable = Flowable.fromPublisher(this.authenticator.authenticate(usernamePasswordCredentials));
        return authenticationResponseFlowable.map(authenticationResponse -> {
            if (authenticationResponse.isAuthenticated()) {
                UserDetails userDetails = (UserDetails)authenticationResponse;
                this.eventPublisher.publishEvent((Object)new LoginSuccessfulEvent(userDetails));
                return this.loginHandler.loginSuccess(userDetails, request);
            }
            AuthenticationFailed authenticationFailed = (AuthenticationFailed)authenticationResponse;
            this.eventPublisher.publishEvent((Object)new LoginFailedEvent(authenticationFailed));
            return this.loginHandler.loginFailed(authenticationFailed);
        }).first((Object)HttpResponse.status((HttpStatus)HttpStatus.UNAUTHORIZED));
    }
}

