/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.endpoints.LogoutControllerConfiguration;
import io.micronaut.security.event.LogoutEvent;
import io.micronaut.security.handlers.LogoutHandler;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Requires(property="micronaut.security.endpoints.logout.enabled", value="true")
@Controller(value="${micronaut.security.endpoints.logout.path:/logout}")
@Secured(value={"isAnonymous()"})
public class LogoutController {
    private final LogoutHandler logoutHandler;
    private final ApplicationEventPublisher eventPublisher;
    private final boolean getAllowed;

    @Inject
    public LogoutController(@Nullable LogoutHandler logoutHandler, ApplicationEventPublisher eventPublisher, LogoutControllerConfiguration logoutControllerConfiguration) {
        this.logoutHandler = logoutHandler;
        this.eventPublisher = eventPublisher;
        this.getAllowed = logoutControllerConfiguration.isGetAllowed();
    }

    @Deprecated
    public LogoutController(@Nullable LogoutHandler logoutHandler, ApplicationEventPublisher eventPublisher) {
        this.logoutHandler = logoutHandler;
        this.eventPublisher = eventPublisher;
        this.getAllowed = false;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public HttpResponse index(HttpRequest<?> request, Authentication authentication) {
        return this.handleLogout(request, authentication);
    }

    @Get
    public HttpResponse indexGet(HttpRequest<?> request, Authentication authentication) {
        if (!this.getAllowed) {
            return HttpResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
        }
        return this.handleLogout(request, authentication);
    }

    protected HttpResponse handleLogout(HttpRequest<?> request, Authentication authentication) {
        this.eventPublisher.publishEvent((Object)new LogoutEvent(authentication));
        if (this.logoutHandler != null) {
            return this.logoutHandler.logout(request);
        }
        return HttpResponse.notFound();
    }
}

