/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.filters;

import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilterOrderProvider;
import io.micronaut.security.handlers.RejectionHandler;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.web.router.RouteMatch;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(value={"/**"})
public class SecurityFilter
extends OncePerRequestHttpServerFilter {
    public static final CharSequence AUTHENTICATION = HttpAttributes.PRINCIPAL.toString();
    public static final CharSequence REJECTION = "micronaut.security.REJECTION";
    public static final CharSequence TOKEN = "micronaut.TOKEN";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityFilter.class);
    protected final Integer order;
    protected final Collection<SecurityRule> securityRules;
    protected final Collection<AuthenticationFetcher> authenticationFetchers;
    protected final RejectionHandler rejectionHandler;

    public SecurityFilter(Collection<SecurityRule> securityRules, Collection<AuthenticationFetcher> authenticationFetchers, RejectionHandler rejectionHandler, @Nullable SecurityFilterOrderProvider securityFilterOrderProvider) {
        this.securityRules = securityRules;
        this.authenticationFetchers = authenticationFetchers;
        this.rejectionHandler = rejectionHandler;
        this.order = securityFilterOrderProvider != null ? securityFilterOrderProvider.getOrder() : 0;
    }

    public int getOrder() {
        return this.order;
    }

    protected Publisher<MutableHttpResponse<?>> doFilterOnce(HttpRequest<?> request, ServerFilterChain chain) {
        String method = request.getMethod().toString();
        String path = request.getPath();
        RouteMatch routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).orElse(null);
        return Flowable.fromIterable(this.authenticationFetchers).flatMap(authenticationFetcher -> authenticationFetcher.fetchAuthentication(request)).firstElement().doOnEvent((authentication, throwable) -> {
            if (authentication != null) {
                request.setAttribute(AUTHENTICATION, authentication);
                Map<String, Object> attributes = authentication.getAttributes();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attributes: {}", (Object)attributes.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
                }
            } else {
                request.setAttribute(AUTHENTICATION, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No Authentication fetched for request. {} {}.", (Object)method, (Object)path);
                }
            }
        }).toFlowable().flatMap(authentication -> this.checkRules(request, chain, routeMatch, authentication.getAttributes(), true)).switchIfEmpty((Publisher)Flowable.defer(() -> this.checkRules(request, chain, routeMatch, null, false)));
    }

    protected Publisher<MutableHttpResponse<?>> checkRules(HttpRequest<?> request, ServerFilterChain chain, @Nullable RouteMatch routeMatch, @Nullable Map<String, Object> attributes, boolean forbidden) {
        String method = request.getMethod().toString();
        String path = request.getPath();
        for (SecurityRule rule : this.securityRules) {
            SecurityRuleResult result = rule.check(request, routeMatch, attributes);
            if (result == SecurityRuleResult.REJECTED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unauthorized request {} {}. The rule provider {} rejected the request.", new Object[]{method, path, rule.getClass().getName()});
                }
                request.setAttribute(REJECTION, (Object)(forbidden ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED));
                return this.rejectionHandler.reject(request, forbidden);
            }
            if (result != SecurityRuleResult.ALLOWED) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Authorized request {} {}. The rule provider {} authorized the request.", new Object[]{method, path, rule.getClass().getName()});
            }
            return chain.proceed(request);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authorized request {} {}. No rule provider authorized or rejected the request.", (Object)method, (Object)path);
        }
        request.setAttribute(REJECTION, (Object)(forbidden ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED));
        return this.rejectionHandler.reject(request, forbidden);
    }
}

