/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.filters;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.security.filters.SecurityFilterOrderProvider;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Requires(missingBeans={SecurityFilterOrderProvider.class})
@Singleton
public class SessionSecurityFilterOrderProvider
implements SecurityFilterOrderProvider {
    private static final Integer ORDER = 100;
    private final BeanContext beanContext;

    public SessionSecurityFilterOrderProvider() {
        this.beanContext = null;
    }

    @Inject
    public SessionSecurityFilterOrderProvider(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public int getOrder() {
        if (this.beanContext == null) {
            return ORDER;
        }
        boolean configurationPresent = Stream.of("io.micronaut.configuration.metrics.micrometer", "io.micronaut.session").map(arg_0 -> ((BeanContext)this.beanContext).findBeanConfiguration(arg_0)).anyMatch(Optional::isPresent);
        if (configurationPresent) {
            return ORDER;
        }
        return 0;
    }
}

