/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.handlers;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.handlers.ForbiddenRejectionUriProvider;
import io.micronaut.security.handlers.HttpStatusCodeRejectionHandler;
import io.micronaut.security.handlers.RedirectRejectionHandlerConfiguration;
import io.micronaut.security.handlers.RejectionHandler;
import io.micronaut.security.handlers.UnauthorizedRejectionUriProvider;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Secondary
@Replaces(value=HttpStatusCodeRejectionHandler.class)
@Requirements(value={@Requires(beans={UnauthorizedRejectionUriProvider.class, ForbiddenRejectionUriProvider.class, RedirectRejectionHandlerConfiguration.class}), @Requires(property="micronaut.security.redirect.enabled", notEquals="false")})
public class RedirectRejectionHandler
implements RejectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectRejectionHandler.class);
    private final UnauthorizedRejectionUriProvider unauthorizedRejectionUriProvider;
    private final ForbiddenRejectionUriProvider forbiddenRejectionUriProvider;
    private final RedirectRejectionHandlerConfiguration redirectRejectionHandlerConfiguration;

    public RedirectRejectionHandler(UnauthorizedRejectionUriProvider unauthorizedRejectionUriProvider, ForbiddenRejectionUriProvider forbiddenRejectionUriProvider, RedirectRejectionHandlerConfiguration redirectRejectionHandlerConfiguration) {
        this.unauthorizedRejectionUriProvider = unauthorizedRejectionUriProvider;
        this.forbiddenRejectionUriProvider = forbiddenRejectionUriProvider;
        this.redirectRejectionHandlerConfiguration = redirectRejectionHandlerConfiguration;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> reject(HttpRequest<?> request, boolean forbidden) {
        return Flowable.create(emitter -> {
            block5: {
                if (this.shouldHandleRequest(request)) {
                    try {
                        URI location = new URI(this.getRedirectUri(request, forbidden).orElse("/"));
                        if (!request.getUri().equals(location)) {
                            emitter.onNext(this.httpResponseWithUri(location));
                            break block5;
                        }
                        emitter.onNext((Object)HttpResponse.status((HttpStatus)(forbidden ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED)));
                    }
                    catch (URISyntaxException e) {
                        emitter.onError((Throwable)e);
                    }
                } else {
                    emitter.onNext((Object)HttpResponse.status((HttpStatus)(forbidden ? HttpStatus.FORBIDDEN : HttpStatus.UNAUTHORIZED)));
                }
            }
            emitter.onComplete();
        }, (BackpressureStrategy)BackpressureStrategy.ERROR);
    }

    protected boolean shouldHandleRequest(HttpRequest<?> request) {
        return request.getHeaders().accept().stream().anyMatch(mediaType -> mediaType.equals((Object)MediaType.TEXT_HTML_TYPE));
    }

    @Deprecated
    protected MutableHttpResponse<?> httpResponseWithUri(String uri) throws URISyntaxException {
        URI location = new URI(uri);
        return this.httpResponseWithUri(location);
    }

    protected MutableHttpResponse<?> httpResponseWithUri(URI location) {
        return HttpResponseFactory.INSTANCE.status(this.redirectionHttpStatus()).headers(headers -> headers.location(location));
    }

    protected HttpStatus redirectionHttpStatus() {
        return this.redirectRejectionHandlerConfiguration.getHttpStatus();
    }

    protected Optional<String> getRedirectUri(HttpRequest<?> request, boolean forbidden) {
        Optional<String> uri;
        Optional<String> optional = uri = forbidden ? this.forbiddenRejectionUriProvider.getForbiddenRedirectUri(request) : this.unauthorizedRejectionUriProvider.getUnauthorizedRedirectUri(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("redirect uri: {}", uri);
        }
        return uri;
    }
}

