/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.InterceptUrlMapRule;
import io.micronaut.security.rules.SecuredAnnotationRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.web.router.RouteMatch;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IpPatternsRule
extends AbstractSecurityRule {
    public static final Integer ORDER = SecuredAnnotationRule.ORDER - 100;
    private static final Logger LOG = LoggerFactory.getLogger(InterceptUrlMapRule.class);
    private final List<Pattern> patternList;

    @Deprecated
    public IpPatternsRule(TokenConfiguration tokenConfiguration, SecurityConfiguration securityConfiguration) {
        super(tokenConfiguration);
        this.patternList = securityConfiguration.getIpPatterns().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    @Inject
    public IpPatternsRule(RolesFinder rolesFinder, SecurityConfiguration securityConfiguration) {
        super(rolesFinder);
        this.patternList = securityConfiguration.getIpPatterns().stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public int getOrder() {
        return ORDER;
    }

    @Override
    public SecurityRuleResult check(HttpRequest request, @Nullable RouteMatch routeMatch, @Nullable Map<String, Object> claims) {
        if (this.patternList.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No IP patterns provided. Skipping host address check.");
            }
            return SecurityRuleResult.UNKNOWN;
        }
        String hostAddress = request.getRemoteAddress().getAddress().getHostAddress();
        if (this.patternList.stream().anyMatch(pattern -> pattern.pattern().equals("0.0.0.0") || pattern.matcher(hostAddress).matches())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("One or more of the IP patterns matched the host address [{}]. Continuing request processing.", (Object)hostAddress);
            }
            return SecurityRuleResult.UNKNOWN;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("None of the IP patterns [{}] matched the host address [{}]. Rejecting the request.", this.patternList.stream().map(Pattern::pattern).collect(Collectors.toList()), (Object)hostAddress);
        }
        return SecurityRuleResult.REJECTED;
    }
}

