/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.rules.AbstractSecurityRule;
import io.micronaut.security.rules.ConfigurationInterceptUrlMapRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SecuredAnnotationRule
extends AbstractSecurityRule {
    public static final Integer ORDER = ConfigurationInterceptUrlMapRule.ORDER - 100;

    @Deprecated
    public SecuredAnnotationRule(TokenConfiguration tokenConfiguration) {
        super(tokenConfiguration);
    }

    @Inject
    public SecuredAnnotationRule(RolesFinder rolesFinder) {
        super(rolesFinder);
    }

    @Override
    public SecurityRuleResult check(HttpRequest request, @Nullable RouteMatch routeMatch, @Nullable Map<String, Object> claims) {
        Optional optionalValue;
        MethodBasedRouteMatch methodRoute;
        if (routeMatch instanceof MethodBasedRouteMatch && (methodRoute = (MethodBasedRouteMatch)routeMatch).hasAnnotation(Secured.class) && (optionalValue = methodRoute.getValue(Secured.class, String[].class)).isPresent()) {
            List<Object> values = Arrays.asList((Object[])optionalValue.get());
            if (values.contains("denyAll()")) {
                return SecurityRuleResult.REJECTED;
            }
            return this.compareRoles(values, this.getRoles(claims));
        }
        return SecurityRuleResult.UNKNOWN;
    }

    public int getOrder() {
        return ORDER;
    }
}

