/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.basicauth;

import io.micronaut.context.annotation.Requires;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationUserDetailsAdapter;
import io.micronaut.security.authentication.Authenticator;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import io.micronaut.security.token.config.TokenConfiguration;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.token.basic-auth.enabled", notEquals="false")
@Singleton
public class BasicAuthTokenValidator
implements TokenValidator {
    public static final Integer ORDER = 0;
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthTokenValidator.class);
    protected final Authenticator authenticator;
    private final String rolesKeyName;

    @Deprecated
    public BasicAuthTokenValidator(Authenticator authenticator) {
        this.authenticator = authenticator;
        this.rolesKeyName = "roles";
    }

    @Inject
    public BasicAuthTokenValidator(Authenticator authenticator, TokenConfiguration tokenConfiguration) {
        this.authenticator = authenticator;
        this.rolesKeyName = tokenConfiguration.getRolesName();
    }

    @Override
    public Publisher<Authentication> validateToken(String encodedToken) {
        Optional<UsernamePasswordCredentials> creds = this.credsFromEncodedToken(encodedToken);
        if (creds.isPresent()) {
            Flowable authenticationResponse = Flowable.fromPublisher(this.authenticator.authenticate(creds.get()));
            return authenticationResponse.switchMap(response -> {
                if (response.isAuthenticated()) {
                    UserDetails userDetails = (UserDetails)response;
                    return Flowable.just((Object)new AuthenticationUserDetailsAdapter(userDetails, this.rolesKeyName));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not authenticate {}", (Object)((UsernamePasswordCredentials)creds.get()).getUsername());
                }
                return Flowable.empty();
            });
        }
        return Flowable.empty();
    }

    public int getOrder() {
        return ORDER;
    }

    private Optional<UsernamePasswordCredentials> credsFromEncodedToken(String encodedToken) {
        byte[] decoded;
        try {
            decoded = Base64.getDecoder().decode(encodedToken);
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while trying to Base 64 decode: {}", (Object)encodedToken);
            }
            return Optional.empty();
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delim = token.indexOf(":");
        if (delim < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bad format of the basic auth header - Delimiter : not found");
            }
            return Optional.empty();
        }
        String username = token.substring(0, delim);
        String password = token.substring(delim + 1);
        return Optional.of(new UsernamePasswordCredentials(username, password));
    }
}

