/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.writer;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.security.token.writer.HttpHeaderTokenWriterConfiguration;
import io.micronaut.security.token.writer.TokenWriter;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(property="micronaut.security.token.writer.header.enabled", notEquals="false"), @Requires(beans={HttpHeaderTokenWriterConfiguration.class})})
public class HttpHeaderTokenWriter
implements TokenWriter {
    protected final HttpHeaderTokenWriterConfiguration httpHeaderTokenWriterConfiguration;

    public HttpHeaderTokenWriter(HttpHeaderTokenWriterConfiguration httpHeaderTokenWriterConfiguration) {
        this.httpHeaderTokenWriterConfiguration = httpHeaderTokenWriterConfiguration;
    }

    protected String getHeaderName() {
        return this.httpHeaderTokenWriterConfiguration.getHeaderName();
    }

    @Override
    public void writeToken(MutableHttpRequest<?> request, String token) {
        request.header((CharSequence)this.getHeaderName(), (CharSequence)this.headerValue(token));
    }

    protected String headerValue(String token) {
        StringBuilder sb = new StringBuilder();
        if (this.httpHeaderTokenWriterConfiguration.getPrefix() != null) {
            sb.append(this.httpHeaderTokenWriterConfiguration.getPrefix());
            if (!this.httpHeaderTokenWriterConfiguration.getPrefix().endsWith(" ")) {
                sb.append(" ");
            }
        }
        sb.append(token);
        return sb.toString();
    }
}

