/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.utils;

import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.utils.SecurityService;
import java.security.Principal;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class DefaultSecurityService
implements SecurityService {
    @Override
    public Optional<String> username() {
        return this.getAuthentication().map(Principal::getName);
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return ServerRequestContext.currentRequest().flatMap(request -> request.getUserPrincipal(Authentication.class));
    }

    @Override
    public boolean isAuthenticated() {
        return this.getAuthentication().isPresent();
    }

    @Override
    public boolean hasRole(String role) {
        return this.hasRole(role, "roles");
    }

    @Override
    public boolean hasRole(String role, String rolesKey) {
        if (role == null || rolesKey == null) {
            return false;
        }
        return this.getAuthentication().map(authentication -> {
            if (authentication.getAttributes() != null && authentication.getAttributes().containsKey(rolesKey)) {
                Object authorities = authentication.getAttributes().get(rolesKey);
                if (authorities instanceof Collection) {
                    return ((Collection)authorities).contains(role);
                }
                if (authorities instanceof String) {
                    return ((String)authorities).equalsIgnoreCase(role);
                }
            }
            return false;
        }).orElse(false);
    }
}

