/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave;

import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.ReactiveInvocationInstrumenterFactory;
import io.micronaut.tracing.instrument.util.TracingInvocationInstrumenterFactory;
import javax.inject.Singleton;

@Singleton
@Requires(beans={Tracing.class})
@Internal
public final class BraveTracingInvocationInstrumenter
implements ReactiveInvocationInstrumenterFactory,
TracingInvocationInstrumenterFactory {
    private final CurrentTraceContext currentTraceContext;

    public BraveTracingInvocationInstrumenter(Tracing tracing) {
        this.currentTraceContext = tracing.currentTraceContext();
    }

    public InvocationInstrumenter newReactiveInvocationInstrumenter() {
        return this.newTracingInvocationInstrumenter();
    }

    @Override
    public InvocationInstrumenter newTracingInvocationInstrumenter() {
        TraceContext invocationContext = this.currentTraceContext.get();
        if (invocationContext != null) {
            return () -> {
                CurrentTraceContext.Scope activeScope = this.currentTraceContext.maybeScope(invocationContext);
                return cleanup -> activeScope.close();
            };
        }
        return null;
    }
}

