/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.http;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.tracing.brave.instrument.http.BraveTracingServerFilter;
import io.micronaut.tracing.instrument.http.AbstractOpenTracingFilter;
import io.micronaut.tracing.instrument.http.HttpHeadersTextMap;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.instrument.util.TracingPublisher;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracer;
import io.opentracing.propagation.Format;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.server.path:/**}"})
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={NoopTracer.class}), @Requires(missingBeans={BraveTracingServerFilter.class})})
public class OpenTracingServerFilter
extends AbstractOpenTracingFilter
implements HttpServerFilter {
    private static final CharSequence APPLIED = OpenTracingServerFilter.class.getName() + "-applied";
    private static final CharSequence CONTINUE = OpenTracingServerFilter.class.getName() + "-continue";

    public OpenTracingServerFilter(Tracer tracer) {
        super(tracer);
    }

    public Publisher<MutableHttpResponse<?>> doFilter(final HttpRequest<?> request, ServerFilterChain chain) {
        Publisher responsePublisher = chain.proceed(request);
        boolean applied = request.getAttribute(APPLIED, Boolean.class).orElse(false);
        final boolean continued = request.getAttribute(CONTINUE, Boolean.class).orElse(false);
        if (applied && !continued) {
            return responsePublisher;
        }
        if (!applied) {
            request.setAttribute(APPLIED, (Object)true);
        }
        SpanContext spanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersTextMap(request.getHeaders()));
        request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN_CONTEXT, (Object)spanContext);
        Tracer.SpanBuilder spanBuilder = this.newSpan(request, spanContext);
        return new TracingPublisher(responsePublisher, this.tracer, spanBuilder){

            @Override
            protected void doOnSubscribe(@NonNull Span span) {
                span.setTag("http.server", true);
                request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
            }

            protected void doOnNext(@NonNull Object object, @NonNull Span span) {
                if (object instanceof HttpResponse) {
                    HttpResponse response = (HttpResponse)object;
                    OpenTracingServerFilter.this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersTextMap(response.getHeaders()));
                    OpenTracingServerFilter.this.setResponseTags(request, response, span);
                }
            }

            @Override
            protected void doOnError(@NotNull Throwable throwable, @NotNull Span span) {
                request.setAttribute(CONTINUE, (Object)true);
            }

            @Override
            protected boolean isContinued() {
                return continued;
            }

            @Override
            protected boolean isFinishOnError() {
                return false;
            }
        };
    }

    public int getOrder() {
        return ServerFilterPhase.TRACING.order();
    }
}

