/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave;

import brave.CurrentSpanCustomizer;
import brave.SpanCustomizer;
import brave.Tracing;
import brave.opentracing.BraveTracer;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.tracing.brave.AsyncReporterConfiguration;
import io.micronaut.tracing.brave.BraveTracerConfiguration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import javax.inject.Singleton;
import zipkin2.Span;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;

@Factory
@Requires(beans={BraveTracerConfiguration.class})
public class BraveTracerFactory {
    private final BraveTracerConfiguration braveTracerConfiguration;

    public BraveTracerFactory(BraveTracerConfiguration braveTracerConfiguration) {
        this.braveTracerConfiguration = braveTracerConfiguration;
    }

    @Bean(preDestroy="close")
    @Singleton
    @Requires(classes={Tracing.class})
    Tracing braveTracing(@Nullable Reporter<Span> reporter) {
        Tracing.Builder builder = this.braveTracerConfiguration.getTracingBuilder();
        if (reporter != null) {
            builder.spanReporter(reporter);
        } else {
            builder.spanReporter(Reporter.NOOP);
        }
        return builder.build();
    }

    @Singleton
    @Requirements(value={@Requires(beans={Tracing.class}), @Requires(missingBeans={SpanCustomizer.class})})
    SpanCustomizer spanCustomizer(Tracing tracing) {
        return CurrentSpanCustomizer.create((Tracing)tracing);
    }

    @Singleton
    @Requires(classes={BraveTracer.class, Tracer.class})
    @Primary
    Tracer braveTracer(Tracing tracing) {
        BraveTracer braveTracer = BraveTracer.create((Tracing)tracing);
        GlobalTracer.registerIfAbsent((Tracer)braveTracer);
        return braveTracer;
    }

    @Prototype
    @Requirements(value={@Requires(beans={AsyncReporterConfiguration.class}), @Requires(missingBeans={Reporter.class})})
    AsyncReporter<Span> asyncReporter(AsyncReporterConfiguration configuration) {
        return configuration.getBuilder().build();
    }
}

