/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave;

import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.tracing.brave.BraveTracerConfiguration;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
@Requires(beans={BraveTracerConfiguration.HttpClientSenderConfiguration.class})
public class ZipkinServiceInstanceList
implements ServiceInstanceList {
    public static final String SERVICE_ID = "zipkin";
    private final BraveTracerConfiguration.HttpClientSenderConfiguration configuration;

    public ZipkinServiceInstanceList(BraveTracerConfiguration.HttpClientSenderConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getID() {
        return SERVICE_ID;
    }

    public List<ServiceInstance> getInstances() {
        List<URI> servers = this.configuration.getBuilder().getServers();
        return servers.stream().map(uri -> ServiceInstance.builder((String)SERVICE_ID, (URI)uri).build()).collect(Collectors.toList());
    }
}

