/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.brave.instrument.http.AbstractBraveTracingFilter;
import io.micronaut.tracing.brave.instrument.http.HttpClientTracingPublisher;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.client.path:/**}"})
@Requires(beans={HttpClientHandler.class})
public class BraveTracingClientFilter
extends AbstractBraveTracingFilter
implements HttpClientFilter {
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler;

    public BraveTracingClientFilter(HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler, HttpTracing httpTracing) {
        super(httpTracing);
        this.clientHandler = clientHandler;
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        Publisher requestPublisher = chain.proceed(request);
        return new HttpClientTracingPublisher(requestPublisher, request, this.clientHandler, this.httpTracing);
    }
}

