/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import io.micronaut.tracing.instrument.util.ScopePropagationPublisher;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class HttpServerTracingPublisher
implements Publishers.MicronautPublisher<MutableHttpResponse<?>> {
    private final Publisher<MutableHttpResponse<?>> publisher;
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler;
    private final HttpRequest<?> request;
    private final Tracer tracer;
    private final io.opentracing.Tracer openTracer;
    private final Span initialSpan;

    HttpServerTracingPublisher(Publisher<MutableHttpResponse<?>> publisher, HttpRequest<?> request, HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler, HttpTracing httpTracing, io.opentracing.Tracer openTracer, Span initialSpan) {
        this.publisher = publisher;
        this.request = request;
        this.initialSpan = initialSpan;
        this.serverHandler = serverHandler;
        Tracing tracing = httpTracing.tracing();
        this.tracer = tracing.tracer();
        this.openTracer = openTracer;
    }

    public void subscribe(final Subscriber<? super MutableHttpResponse<?>> actual) {
        final Span span = this.initialSpan;
        this.request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            this.publisher.subscribe(new Subscriber<MutableHttpResponse<?>>(){

                public void onSubscribe(Subscription s) {
                    try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(span);){
                        actual.onSubscribe(s);
                    }
                }

                public void onNext(MutableHttpResponse<?> response) {
                    try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(span);){
                        Object o;
                        Optional body = response.getBody();
                        if (body.isPresent() && Publishers.isConvertibleToPublisher(o = body.get())) {
                            Class<?> type = o.getClass();
                            Publisher resultPublisher = (Publisher)Publishers.convertPublisher(o, Publisher.class);
                            ScopePropagationPublisher scopedPublisher = new ScopePropagationPublisher(resultPublisher, HttpServerTracingPublisher.this.openTracer, HttpServerTracingPublisher.this.openTracer.activeSpan());
                            response.body(Publishers.convertPublisher(scopedPublisher, type));
                        }
                        HttpServerTracingPublisher.this.serverHandler.handleSend(HttpServerTracingPublisher.this.mapResponse(HttpServerTracingPublisher.this.request, response), span);
                        actual.onNext(response);
                    }
                }

                public void onError(Throwable error) {
                    try (Tracer.SpanInScope ignored = HttpServerTracingPublisher.this.tracer.withSpanInScope(span);){
                        int statusCode = 500;
                        if (error instanceof HttpStatusException) {
                            statusCode = ((HttpStatusException)error).getStatus().getCode();
                        }
                        HttpServerTracingPublisher.this.serverHandler.handleSend(HttpServerTracingPublisher.this.mapResponse(HttpServerTracingPublisher.this.request, statusCode, error), span);
                        actual.onError(error);
                    }
                }

                public void onComplete() {
                    actual.onComplete();
                }
            });
        }
    }

    private HttpServerResponse mapResponse(final HttpRequest<?> request, final HttpResponse<?> response) {
        return new HttpServerResponse(){

            public Object unwrap() {
                return response;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return response.getStatus().getCode();
            }
        };
    }

    private HttpServerResponse mapResponse(final HttpRequest<?> request, final int statusCode, final Throwable error) {
        return new HttpServerResponse(){

            public Throwable error() {
                return error;
            }

            public Object unwrap() {
                return this;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return statusCode;
            }
        };
    }
}

