/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.log;

import brave.internal.codec.HexCodec;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

final class Slf4jScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    private static final String LEGACY_EXPORTABLE_NAME = "X-Span-Export";
    private static final String LEGACY_PARENT_ID_NAME = "X-B3-ParentSpanId";
    private static final String LEGACY_TRACE_ID_NAME = "X-B3-TraceId";
    private static final String LEGACY_SPAN_ID_NAME = "X-B3-SpanId";
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jScopeDecorator.class);

    Slf4jScopeDecorator() {
    }

    public CurrentTraceContext.Scope decorateScope(final TraceContext currentSpan, final CurrentTraceContext.Scope scope) {
        final String previousTraceId = MDC.get((String)"traceId");
        final String previousParentId = MDC.get((String)"parentId");
        final String previousSpanId = MDC.get((String)"spanId");
        final String spanExportable = MDC.get((String)"spanExportable");
        final String legacyPreviousTraceId = MDC.get((String)LEGACY_TRACE_ID_NAME);
        final String legacyPreviousParentId = MDC.get((String)LEGACY_PARENT_ID_NAME);
        final String legacyPreviousSpanId = MDC.get((String)LEGACY_SPAN_ID_NAME);
        final String legacySpanExportable = MDC.get((String)LEGACY_EXPORTABLE_NAME);
        if (currentSpan != null) {
            String traceIdString = currentSpan.traceIdString();
            MDC.put((String)"traceId", (String)traceIdString);
            MDC.put((String)LEGACY_TRACE_ID_NAME, (String)traceIdString);
            String parentId = currentSpan.parentId() != null ? HexCodec.toLowerHex((long)currentSpan.parentId()) : null;
            Slf4jScopeDecorator.replace("parentId", parentId);
            Slf4jScopeDecorator.replace(LEGACY_PARENT_ID_NAME, parentId);
            String spanId = HexCodec.toLowerHex((long)currentSpan.spanId());
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)LEGACY_SPAN_ID_NAME, (String)spanId);
            String sampled = String.valueOf(currentSpan.sampled());
            MDC.put((String)"spanExportable", (String)sampled);
            MDC.put((String)LEGACY_EXPORTABLE_NAME, (String)sampled);
            this.log("Starting scope for span: {}", currentSpan);
            if (currentSpan.parentId() != null && LOG.isTraceEnabled()) {
                LOG.trace("With parent: {}", (Object)currentSpan.parentId());
            }
        } else {
            MDC.remove((String)"traceId");
            MDC.remove((String)"parentId");
            MDC.remove((String)"spanId");
            MDC.remove((String)"spanExportable");
            MDC.remove((String)LEGACY_TRACE_ID_NAME);
            MDC.remove((String)LEGACY_PARENT_ID_NAME);
            MDC.remove((String)LEGACY_SPAN_ID_NAME);
            MDC.remove((String)LEGACY_EXPORTABLE_NAME);
        }
        class ThreadContextCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            ThreadContextCurrentTraceContextScope() {
            }

            public void close() {
                Slf4jScopeDecorator.this.log("Closing scope for span: {}", currentSpan);
                scope.close();
                Slf4jScopeDecorator.replace("traceId", previousTraceId);
                Slf4jScopeDecorator.replace("parentId", previousParentId);
                Slf4jScopeDecorator.replace("spanId", previousSpanId);
                Slf4jScopeDecorator.replace("spanExportable", spanExportable);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_TRACE_ID_NAME, legacyPreviousTraceId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_PARENT_ID_NAME, legacyPreviousParentId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_SPAN_ID_NAME, legacyPreviousSpanId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_EXPORTABLE_NAME, legacySpanExportable);
            }
        }
        return new ThreadContextCurrentTraceContextScope();
    }

    private void log(String text, TraceContext span) {
        if (span == null) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(text, (Object)span);
        }
    }

    private static void replace(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }
}

