/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.http;

import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.filter.HttpFilter;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Optional;

public abstract class AbstractOpenTracingFilter
implements HttpFilter {
    public static final String CLIENT_PATH = "${tracing.http.client.path:/**}";
    public static final String SERVER_PATH = "${tracing.http.server.path:/**}";
    public static final String TAG_METHOD = "http.method";
    public static final String TAG_PATH = "http.path";
    public static final String TAG_ERROR = "error";
    public static final String TAG_HTTP_STATUS_CODE = "http.status_code";
    public static final String TAG_HTTP_CLIENT = "http.client";
    public static final String TAG_HTTP_SERVER = "http.server";
    private static final int HTTP_SUCCESS_CODE_UPPER_LIMIT = 299;
    protected final Tracer tracer;

    public AbstractOpenTracingFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    protected void setResponseTags(HttpRequest<?> request, HttpResponse<?> response, Span span) {
        HttpStatus status = response.getStatus();
        int code = status.getCode();
        if (code > 299) {
            span.setTag(TAG_HTTP_STATUS_CODE, (Number)code);
            span.setTag(TAG_ERROR, status.getReason());
        }
        request.getAttribute((CharSequence)HttpAttributes.ERROR, Throwable.class).ifPresent(error -> this.setErrorTags(span, (Throwable)error));
    }

    protected void setErrorTags(Span span, Throwable error) {
        if (error != null) {
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
            span.setTag(TAG_ERROR, message);
        }
    }

    protected String resolveSpanName(HttpRequest<?> request) {
        Optional route = request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class);
        return route.map(s -> request.getMethodName() + " " + s).orElse(request.getMethodName() + " " + request.getPath());
    }

    protected Tracer.SpanBuilder newSpan(HttpRequest<?> request, SpanContext spanContext) {
        String spanName = this.resolveSpanName(request);
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(spanName).asChildOf(spanContext);
        spanBuilder.withTag(TAG_METHOD, request.getMethodName());
        String path = request.getPath();
        spanBuilder.withTag(TAG_PATH, path);
        return spanBuilder;
    }
}

