/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.http.HttpServerHandler;
import brave.http.HttpServerRequest;
import brave.http.HttpServerResponse;
import brave.http.HttpTracing;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.filter.ServerFilterPhase;
import io.micronaut.tracing.brave.instrument.http.AbstractBraveTracingFilter;
import io.micronaut.tracing.brave.instrument.http.HttpServerTracingPublisher;
import io.opentracing.Tracer;
import org.reactivestreams.Publisher;

@Filter(value={"${tracing.http.server.path:/**}"})
@Requires(beans={HttpServerHandler.class})
public class BraveTracingServerFilter
extends AbstractBraveTracingFilter
implements HttpServerFilter {
    private final HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler;
    private final Tracer openTracer;

    public BraveTracingServerFilter(HttpTracing httpTracing, Tracer openTracer, HttpServerHandler<HttpServerRequest, HttpServerResponse> serverHandler) {
        super(httpTracing);
        this.openTracer = openTracer;
        this.serverHandler = serverHandler;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        HttpServerRequest httpServerRequest = this.mapRequest(request);
        Span span = this.serverHandler.handleReceive(httpServerRequest);
        return new HttpServerTracingPublisher(chain.proceed(request), request, this.serverHandler, this.httpTracing, this.openTracer, span);
    }

    public int getOrder() {
        return ServerFilterPhase.TRACING.order();
    }

    private HttpServerRequest mapRequest(final HttpRequest<?> request) {
        return new HttpServerRequest(){

            public String method() {
                return request.getMethodName();
            }

            public String path() {
                return request.getPath();
            }

            public String url() {
                return request.getUri().toString();
            }

            public String header(String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Object unwrap() {
                return request;
            }
        };
    }
}

