/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.sender;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.tracing.brave.BraveTracerConfiguration;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Singleton;
import zipkin2.reporter.Sender;

@Factory
@Requires(beans={BraveTracerConfiguration.HttpClientSenderConfiguration.class})
public class HttpClientSenderFactory {
    private final BraveTracerConfiguration.HttpClientSenderConfiguration configuration;
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    protected HttpClientSenderFactory(BraveTracerConfiguration.HttpClientSenderConfiguration configuration, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this.configuration = configuration;
        this.invocationInstrumenterFactories = invocationInstrumenterFactories;
    }

    @Singleton
    @Requires(missingBeans={Sender.class})
    Sender zipkinSender(Provider<LoadBalancerResolver> loadBalancerResolver) {
        return this.configuration.getBuilder().invocationInstrumenterFactories(this.invocationInstrumenterFactories).build(loadBalancerResolver);
    }
}

