/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.jaeger;

import io.jaegertracing.Configuration;
import io.jaegertracing.spi.MetricsFactory;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.runtime.ApplicationConfiguration;
import javax.inject.Inject;

@ConfigurationProperties(value="tracing.jaeger")
public class JaegerConfiguration
implements Toggleable {
    public static final String PREFIX = "tracing.jaeger";
    public static final boolean DEFAULT_ENABLED = false;
    @ConfigurationBuilder(prefixes={"with"}, includes={"tracerTags"})
    protected final Configuration configuration;
    private boolean enabled = false;
    private boolean expandExceptionLogs;
    private boolean zipkinSharedRpcSpan;

    public JaegerConfiguration(ApplicationConfiguration applicationConfiguration) {
        if (StringUtils.isEmpty((CharSequence)System.getProperty("JAEGER_SERVICE_NAME"))) {
            System.setProperty("JAEGER_SERVICE_NAME", applicationConfiguration.getName().orElse("application"));
        }
        this.configuration = Configuration.fromEnv();
    }

    public boolean isExpandExceptionLogs() {
        return this.expandExceptionLogs;
    }

    public void setExpandExceptionLogs(boolean expandExceptionLogs) {
        this.expandExceptionLogs = expandExceptionLogs;
    }

    public boolean isZipkinSharedRpcSpan() {
        return this.zipkinSharedRpcSpan;
    }

    public void setZipkinSharedRpcSpan(boolean zipkinSharedRpcSpan) {
        this.zipkinSharedRpcSpan = zipkinSharedRpcSpan;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Inject
    public void setSamplerConfiguration(@Nullable Configuration.SamplerConfiguration samplerConfiguration) {
        if (samplerConfiguration != null) {
            this.configuration.withSampler(samplerConfiguration);
        }
    }

    @Inject
    public void setReporterConfiguration(@Nullable Configuration.ReporterConfiguration reporterConfiguration) {
        if (reporterConfiguration != null) {
            this.configuration.withReporter(reporterConfiguration);
        }
    }

    @Inject
    public void setSamplerConfiguration(@Nullable JaegerSamplerConfiguration samplerConfiguration) {
        if (samplerConfiguration != null) {
            this.configuration.withSampler(samplerConfiguration.configuration);
        }
    }

    @Inject
    public void setReporterConfiguration(@Nullable JaegerReporterConfiguration reporterConfiguration) {
        if (reporterConfiguration != null) {
            this.configuration.withReporter(reporterConfiguration.configuration);
        }
    }

    @Inject
    public void setCodecConfiguration(@Nullable Configuration.CodecConfiguration codecConfiguration) {
        if (codecConfiguration != null) {
            this.configuration.withCodec(codecConfiguration);
        }
    }

    @Inject
    void setMetricsFactory(@Nullable MetricsFactory metricsFactory) {
        if (metricsFactory != null) {
            this.configuration.withMetricsFactory(metricsFactory);
        }
    }

    @ConfigurationProperties(value="sender")
    public static class JaegerSenderConfiguration {
        @ConfigurationBuilder(prefixes={"with"})
        protected Configuration.SenderConfiguration configuration = Configuration.SenderConfiguration.fromEnv();

        public Configuration.SenderConfiguration getSenderConfiguration() {
            return this.configuration;
        }
    }

    @ConfigurationProperties(value="reporter")
    public static class JaegerReporterConfiguration {
        @ConfigurationBuilder(prefixes={"with"})
        protected Configuration.ReporterConfiguration configuration = Configuration.ReporterConfiguration.fromEnv();

        public Configuration.ReporterConfiguration getReporterConfiguration() {
            return this.configuration;
        }

        @Inject
        public void setSenderConfiguration(@Nullable Configuration.SenderConfiguration senderConfiguration) {
            if (senderConfiguration != null) {
                this.configuration.withSender(senderConfiguration);
            }
        }

        @Inject
        public void setSenderConfiguration(@Nullable JaegerSenderConfiguration senderConfiguration) {
            if (senderConfiguration != null) {
                this.configuration.withSender(senderConfiguration.configuration);
            }
        }
    }

    @ConfigurationProperties(value="sampler")
    public static class JaegerSamplerConfiguration {
        @ConfigurationBuilder(prefixes={"with"})
        protected Configuration.SamplerConfiguration configuration = Configuration.SamplerConfiguration.fromEnv();

        public Configuration.SamplerConfiguration getSamplerConfiguration() {
            return this.configuration;
        }

        public void setProbability(float probability) {
            this.configuration.withParam((Number)Float.valueOf(probability));
        }
    }
}

