/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.util;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.ReactiveInvocationInstrumenterFactory;
import io.micronaut.tracing.instrument.util.TracingInvocationInstrumenterFactory;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import jakarta.inject.Singleton;

@Singleton
@Requirements(value={@Requires(beans={Tracer.class}), @Requires(missingBeans={TracingInvocationInstrumenterFactory.class})})
@Internal
public class OpenTracingInvocationInstrumenter
implements TracingInvocationInstrumenterFactory,
ReactiveInvocationInstrumenterFactory {
    private final Tracer tracer;

    protected OpenTracingInvocationInstrumenter(Tracer tracer) {
        this.tracer = tracer;
    }

    public InvocationInstrumenter newReactiveInvocationInstrumenter() {
        return this.newTracingInvocationInstrumenter();
    }

    @Override
    public InvocationInstrumenter newTracingInvocationInstrumenter() {
        Span activeSpan = this.tracer.activeSpan();
        if (activeSpan != null) {
            return () -> {
                Scope activeScope = this.tracer.scopeManager().activate(activeSpan);
                return cleanup -> activeScope.close();
            };
        }
        return null;
    }
}

