/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.tracing.instrument.http.TraceRequestAttributes;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class HttpClientTracingPublisher
implements Publishers.MicronautPublisher<HttpResponse<?>> {
    private final Publisher<HttpResponse<?>> publisher;
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler;
    private final MutableHttpRequest<?> request;
    private final Tracer tracer;

    HttpClientTracingPublisher(Publisher<HttpResponse<?>> publisher, MutableHttpRequest<?> request, HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler, HttpTracing httpTracing) {
        this.publisher = publisher;
        this.request = request;
        this.clientHandler = clientHandler;
        this.tracer = httpTracing.tracing().tracer();
    }

    public void subscribe(final Subscriber<? super HttpResponse<?>> actual) {
        HttpClientRequest httpClientRequest = this.mapRequest(this.request);
        final Span span = this.clientHandler.handleSend(httpClientRequest);
        this.request.getAttribute((CharSequence)HttpAttributes.SERVICE_ID, String.class).filter(StringUtils::isNotEmpty).ifPresent(arg_0 -> ((Span)span).remoteServiceName(arg_0));
        this.request.setAttribute((CharSequence)TraceRequestAttributes.CURRENT_SPAN, (Object)span);
        try (Tracer.SpanInScope ignored = this.tracer.withSpanInScope(span);){
            this.publisher.subscribe(new Subscriber<HttpResponse<?>>(){

                public void onSubscribe(Subscription s) {
                    try (Tracer.SpanInScope ignored = HttpClientTracingPublisher.this.tracer.withSpanInScope(span);){
                        actual.onSubscribe(s);
                    }
                }

                public void onNext(HttpResponse<?> response) {
                    try (Tracer.SpanInScope ignored = HttpClientTracingPublisher.this.tracer.withSpanInScope(span);){
                        HttpClientTracingPublisher.this.clientHandler.handleReceive(HttpClientTracingPublisher.this.mapResponse((HttpRequest)HttpClientTracingPublisher.this.request, response, null), span);
                        actual.onNext(response);
                    }
                }

                public void onError(Throwable error) {
                    try (Tracer.SpanInScope ignored = HttpClientTracingPublisher.this.tracer.withSpanInScope(span);){
                        if (error instanceof HttpClientResponseException) {
                            HttpClientResponseException e = (HttpClientResponseException)error;
                            HttpClientTracingPublisher.this.clientHandler.handleReceive(HttpClientTracingPublisher.this.mapResponse((HttpRequest)HttpClientTracingPublisher.this.request, e.getResponse(), error), span);
                        } else {
                            span.error(error);
                            span.finish();
                        }
                        actual.onError(error);
                    }
                }

                public void onComplete() {
                    actual.onComplete();
                }
            });
        }
    }

    private HttpClientRequest mapRequest(final MutableHttpRequest<?> request) {
        return new HttpClientRequest(){

            public void header(String name, String value) {
                request.header((CharSequence)name, (CharSequence)value);
            }

            public String method() {
                return request.getMethodName();
            }

            public String path() {
                return request.getPath();
            }

            public String url() {
                return request.getUri().toString();
            }

            public String header(String name) {
                return (String)request.getHeaders().get((CharSequence)name);
            }

            public Object unwrap() {
                return request;
            }
        };
    }

    private HttpClientResponse mapResponse(final HttpRequest<?> request, final HttpResponse<?> response, final Throwable error) {
        return new HttpClientResponse(){

            public Object unwrap() {
                return response;
            }

            public Throwable error() {
                return error;
            }

            public String method() {
                return request.getMethodName();
            }

            public String route() {
                return request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(null);
            }

            public int statusCode() {
                return response.getStatus().getCode();
            }
        };
    }
}

