/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.instrument.kotlin;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.bind.binders.HttpCoroutineContextFactory;
import io.micronaut.tracing.instrument.kotlin.CoroutineTracingDispatcher;
import io.micronaut.tracing.instrument.util.TracingInvocationInstrumenterFactory;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ThreadContextElement;
import org.jetbrains.annotations.NotNull;

@Requires(classes={ThreadContextElement.class, CoroutineContext.class})
@Context
@Singleton
@Internal
final class HttpCoroutineTracingDispatcherFactory
implements HttpCoroutineContextFactory<CoroutineTracingDispatcher> {
    private final List<TracingInvocationInstrumenterFactory> instrumenters;

    HttpCoroutineTracingDispatcherFactory(List<TracingInvocationInstrumenterFactory> instrumenters) {
        this.instrumenters = instrumenters;
    }

    @NotNull
    public CoroutineTracingDispatcher create() {
        return new CoroutineTracingDispatcher(this.instrumenters.stream().map(TracingInvocationInstrumenterFactory::newTracingInvocationInstrumenter).collect(Collectors.toList()));
    }
}

