/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.routes.rules;

import io.micronaut.http.annotation.Body;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.validation.routes.RouteValidationResult;
import io.micronaut.validation.routes.rules.RouteValidationRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MissingParameterRule
implements RouteValidationRule {
    @Override
    public RouteValidationResult validate(UriMatchTemplate template, ParameterElement[] parameters, MethodElement method) {
        List variables = template.getVariableNames();
        List routeVariables = Arrays.stream(parameters).map(Element::getName).collect(Collectors.toList());
        routeVariables.addAll(Arrays.stream(parameters).filter(p -> p.hasAnnotation(Body.class)).map(ParameterElement::getType).filter(Objects::nonNull).flatMap(t -> t.getBeanProperties().stream()).map(Element::getName).collect(Collectors.toList()));
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String v : variables) {
            if (routeVariables.contains(v)) continue;
            errorMessages.add(String.format("The route declares a uri variable named [%s], but no corresponding method argument is present", v));
        }
        return new RouteValidationResult(errorMessages.toArray(new String[0]));
    }
}

