/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.constraints;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.validation.validator.constraints.ConstraintValidator;
import io.micronaut.validation.validator.constraints.ConstraintValidatorContext;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.ValidationException;
import javax.validation.constraints.DecimalMax;

public interface DecimalMaxValidator<T>
extends ConstraintValidator<DecimalMax, T> {
    @Override
    default public boolean isValid(@Nullable T value, @Nonnull AnnotationValue<DecimalMax> annotationMetadata, @Nonnull ConstraintValidatorContext context) {
        int result;
        if (value == null) {
            return true;
        }
        BigDecimal bigDecimal = annotationMetadata.getValue(String.class).map(s -> (BigDecimal)ConversionService.SHARED.convert(s, BigDecimal.class).orElseThrow(() -> new ValidationException(s + " does not represent a valid BigDecimal format."))).orElseThrow(() -> new ValidationException("null does not represent a valid BigDecimal format."));
        boolean inclusive = annotationMetadata.get((CharSequence)"inclusive", Boolean.TYPE).orElse(true);
        try {
            result = this.doComparison(value, bigDecimal);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return inclusive ? result <= 0 : result < 0;
    }

    public int doComparison(@Nonnull T var1, @Nonnull BigDecimal var2);
}

