/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.MessageSource;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.Toggleable;
import io.micronaut.validation.validator.DefaultClockProvider;
import io.micronaut.validation.validator.DefaultValidator;
import io.micronaut.validation.validator.ValidatorConfiguration;
import io.micronaut.validation.validator.constraints.ConstraintValidatorRegistry;
import io.micronaut.validation.validator.constraints.DefaultConstraintValidators;
import io.micronaut.validation.validator.extractors.DefaultValueExtractors;
import io.micronaut.validation.validator.extractors.ValueExtractorRegistry;
import io.micronaut.validation.validator.messages.DefaultValidationMessages;
import java.lang.annotation.ElementType;
import javax.inject.Inject;
import javax.validation.ClockProvider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.valueextraction.ValueExtractor;

@ConfigurationProperties(value="micronaut.validator")
public class DefaultValidatorConfiguration
implements ValidatorConfiguration,
Toggleable,
ValidatorContext {
    @Nullable
    private ConstraintValidatorRegistry constraintValidatorRegistry;
    @Nullable
    private ValueExtractorRegistry valueExtractorRegistry;
    @Nullable
    private ClockProvider clockProvider;
    @Nullable
    private TraversableResolver traversableResolver;
    @Nullable
    private MessageSource messageSource;
    @Nullable
    private ExecutionHandleLocator executionHandleLocator;
    private boolean enabled = true;

    @Override
    @NonNull
    public ConstraintValidatorRegistry getConstraintValidatorRegistry() {
        if (this.constraintValidatorRegistry != null) {
            return this.constraintValidatorRegistry;
        }
        return new DefaultConstraintValidators();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DefaultValidatorConfiguration setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Inject
    public DefaultValidatorConfiguration setConstraintValidatorRegistry(@Nullable ConstraintValidatorRegistry constraintValidatorRegistry) {
        this.constraintValidatorRegistry = constraintValidatorRegistry;
        return this;
    }

    @Override
    @NonNull
    public ValueExtractorRegistry getValueExtractorRegistry() {
        if (this.valueExtractorRegistry != null) {
            return this.valueExtractorRegistry;
        }
        return new DefaultValueExtractors();
    }

    @Inject
    public DefaultValidatorConfiguration setValueExtractorRegistry(@Nullable ValueExtractorRegistry valueExtractorRegistry) {
        this.valueExtractorRegistry = valueExtractorRegistry;
        return this;
    }

    @Override
    @NonNull
    public ClockProvider getClockProvider() {
        if (this.clockProvider != null) {
            return this.clockProvider;
        }
        return new DefaultClockProvider();
    }

    @Inject
    public DefaultValidatorConfiguration setClockProvider(@Nullable ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    @Override
    @NonNull
    public TraversableResolver getTraversableResolver() {
        if (this.traversableResolver != null) {
            return this.traversableResolver;
        }
        return new TraversableResolver(){

            public boolean isReachable(Object object, Path.Node node, Class<?> rootType, Path path, ElementType elementType) {
                return true;
            }

            public boolean isCascadable(Object object, Path.Node node, Class<?> rootType, Path path, ElementType elementType) {
                return true;
            }
        };
    }

    @Inject
    public DefaultValidatorConfiguration setTraversableResolver(@Nullable TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    @Override
    @NonNull
    public MessageSource getMessageSource() {
        if (this.messageSource != null) {
            return this.messageSource;
        }
        return new DefaultValidationMessages();
    }

    @Inject
    public DefaultValidatorConfiguration setMessageSource(@Nullable MessageSource messageSource) {
        this.messageSource = messageSource;
        return this;
    }

    @Override
    @NonNull
    public ExecutionHandleLocator getExecutionHandleLocator() {
        if (this.executionHandleLocator != null) {
            return this.executionHandleLocator;
        }
        return ExecutionHandleLocator.EMPTY;
    }

    @Inject
    public DefaultValidatorConfiguration setExecutionHandleLocator(@Nullable ExecutionHandleLocator executionHandleLocator) {
        this.executionHandleLocator = executionHandleLocator;
        return this;
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        throw new UnsupportedOperationException("Method messageInterpolator(..) not supported");
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        throw new UnsupportedOperationException("Method constraintValidatorFactory(..) not supported");
    }

    public ValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        throw new UnsupportedOperationException("Method parameterNameProvider(..) not supported");
    }

    public ValidatorContext clockProvider(ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
        return this;
    }

    public ValidatorContext addValueExtractor(ValueExtractor<?> extractor) {
        throw new UnsupportedOperationException("Method addValueExtractor(..) not supported");
    }

    public Validator getValidator() {
        return new DefaultValidator(this);
    }
}

