/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.views.ModelAndView;
import io.micronaut.views.View;
import io.micronaut.views.ViewsFilterOrderProvider;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.model.ViewModelProcessor;
import io.micronaut.web.router.qualifier.ProducesMediaTypeQualifier;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={ViewsRenderer.class})
@Filter(value={"/**"})
public class ViewsFilter
implements HttpServerFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ViewsFilter.class);
    protected final Integer order;
    protected final BeanLocator beanLocator;
    private final Collection<ViewModelProcessor> viewModelProcessors;

    public ViewsFilter(BeanLocator beanLocator, @Nullable ViewsFilterOrderProvider viewsFilterOrderProvider, Collection<ViewModelProcessor> viewModelProcessors) {
        this.beanLocator = beanLocator;
        this.order = viewsFilterOrderProvider != null ? Integer.valueOf(viewsFilterOrderProvider.getOrder()) : Integer.valueOf(0);
        this.viewModelProcessors = viewModelProcessors;
    }

    @Deprecated
    public ViewsFilter(BeanLocator beanLocator, @Nullable ViewsFilterOrderProvider viewsFilterOrderProvider) {
        this.beanLocator = beanLocator;
        this.order = viewsFilterOrderProvider != null ? Integer.valueOf(viewsFilterOrderProvider.getOrder()) : Integer.valueOf(0);
        this.viewModelProcessors = new ArrayList<ViewModelProcessor>();
    }

    public int getOrder() {
        return this.order;
    }

    public final Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return Flowable.fromPublisher((Publisher)chain.proceed(request)).switchMap(response -> {
            MediaType type;
            Optional optionalViewsRenderer;
            Object body;
            AnnotationMetadata route;
            Optional<String> optionalView;
            Optional routeMatch = response.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, AnnotationMetadata.class);
            if (routeMatch.isPresent() && (optionalView = this.resolveView(route = (AnnotationMetadata)routeMatch.get(), body = response.body())).isPresent() && (optionalViewsRenderer = this.beanLocator.findBean(ViewsRenderer.class, (Qualifier)new ProducesMediaTypeQualifier(type = route.getValue(Produces.class, MediaType.class).orElse(route.getValue(View.class).isPresent() || body instanceof ModelAndView ? MediaType.TEXT_HTML_TYPE : MediaType.APPLICATION_JSON_TYPE)))).isPresent()) {
                ViewsRenderer viewsRenderer = (ViewsRenderer)optionalViewsRenderer.get();
                Map<String, Object> model = this.populateModel(request, viewsRenderer, body);
                ModelAndView<Map<String, Object>> modelAndView = this.processModelAndView(request, optionalView.get(), model);
                model = modelAndView.getModel().orElse(model);
                String view = modelAndView.getView().orElse(optionalView.get());
                if (viewsRenderer.exists(view)) {
                    Writable writable = viewsRenderer.render(view, model, request);
                    response.contentType(type);
                    response.body((Object)writable);
                    return Flowable.just((Object)response);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("view {} not found ", (Object)view);
                }
                return Flowable.just((Object)HttpResponse.notFound());
            }
            return Flowable.just((Object)response);
        });
    }

    protected ModelAndView<Map<String, Object>> processModelAndView(HttpRequest request, String view, Map<String, Object> model) {
        ModelAndView<Map<String, Object>> modelAndView = new ModelAndView<Map<String, Object>>(view, model);
        if (CollectionUtils.isNotEmpty(this.viewModelProcessors)) {
            for (ViewModelProcessor modelDecorator : this.viewModelProcessors) {
                modelDecorator.process(request, modelAndView);
            }
        }
        return modelAndView;
    }

    protected Map<String, Object> populateModel(HttpRequest request, ViewsRenderer viewsRenderer, Object responseBody) {
        return new HashMap<String, Object>(viewsRenderer.modelOf(this.resolveModel(responseBody)));
    }

    protected Object resolveModel(Object responseBody) {
        if (responseBody instanceof ModelAndView) {
            return ((ModelAndView)responseBody).getModel().orElse(null);
        }
        return responseBody;
    }

    protected Optional<String> resolveView(AnnotationMetadata route, Object responseBody) {
        Optional optionalViewName = route.getValue(View.class);
        if (optionalViewName.isPresent()) {
            return Optional.of((String)optionalViewName.get());
        }
        if (responseBody instanceof ModelAndView) {
            return ((ModelAndView)responseBody).getView();
        }
        return Optional.empty();
    }
}

