/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.csp;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.views.csp.CspConfiguration;
import io.reactivex.Flowable;
import org.reactivestreams.Publisher;

@Filter(value={"${micronaut.views.csp.filter-path:/**}"})
public class CspFilter
implements HttpServerFilter {
    public static final String CSP_HEADER = "Content-Security-Policy";
    public static final String CSP_REPORT_ONLY_HEADER = "Content-Security-Policy-Report-Only";
    protected final CspConfiguration cspConfiguration;

    public CspFilter(CspConfiguration cspConfiguration) {
        this.cspConfiguration = cspConfiguration;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return Flowable.fromPublisher((Publisher)chain.proceed(request)).doOnNext(response -> this.cspConfiguration.getPolicyDirectives().map(StringUtils::trimToNull).ifPresent(directives -> {
            String header = this.cspConfiguration.isReportOnly() ? CSP_REPORT_ONLY_HEADER : CSP_HEADER;
            response.getHeaders().add((CharSequence)header, (CharSequence)directives);
        }));
    }
}

