/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.csp;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.util.Toggleable;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;

@ConfigurationProperties(value="micronaut.views.csp")
public class CspConfiguration
implements Toggleable {
    public static final int NONCE_LENGTH = 16;
    public static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder().withoutPadding();
    public static final String PREFIX = "micronaut.views.csp";
    public static final String FILTER_PATH = "micronaut.views.csp.filter-path";
    public static final boolean DEFAULT_ENABLED = false;
    public static final boolean DEFAULT_REPORT_ONLY = false;
    public static final boolean DEFAULT_ENABLE_NONCE = false;
    public static final boolean DEFAULT_FORCE_SECURE_RANDOM = false;
    public static final String DEFAULT_FILTER_PATH = "/**";
    private static final Random DEFAULT_RANDOM = new Random();
    private static volatile SecureRandom secureRandom = null;
    private boolean enabled = false;
    private String policyDirectives;
    private boolean reportOnly = false;
    private boolean generateNonce = false;
    private String filterPath = "/**";
    private boolean forceSecureRandom = false;
    private Random randomEngine = DEFAULT_RANDOM;

    private Random acquireRandom() {
        if (this.forceSecureRandom) {
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            return secureRandom;
        }
        return this.randomEngine;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<String> getPolicyDirectives() {
        return Optional.of(this.policyDirectives);
    }

    public boolean isReportOnly() {
        return this.reportOnly;
    }

    public boolean isNonceEnabled() {
        return this.generateNonce;
    }

    public boolean isForceSecureRandomEnabled() {
        return this.forceSecureRandom;
    }

    public Random getRandomEngine() {
        return this.randomEngine;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPolicyDirectives(@Nullable String policyDirectives) {
        this.policyDirectives = policyDirectives;
    }

    public void setReportOnly(boolean reportOnly) {
        this.reportOnly = reportOnly;
    }

    public void setGenerateNonce(boolean generateNonce) {
        this.generateNonce = generateNonce;
    }

    public void setForceSecureRandom(boolean forceSecureRandom) {
        this.forceSecureRandom = forceSecureRandom;
    }

    public void setRandomEngine(Random randomEngine) {
        this.randomEngine = randomEngine;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public String generateNonce() {
        byte[] randomBytes = new byte[16];
        this.acquireRandom().nextBytes(randomBytes);
        return BASE64_ENCODER.encodeToString(randomBytes);
    }
}

